import { useState, useEffect } from 'react'
import { ChevronLeft, ChevronRight } from 'lucide-react'
import nutrition1 from '/images/nutrition-1.jpg'
import nutrition2 from '/images/nutrition-2.jpg'
import nutrition3 from '/images/nutrition-3.jpg'
import nutrition4 from '/images/nutrition-4.jpg'
import './ImageSlider.css'

const ImageSlider = () => {
  const [currentIndex, setCurrentIndex] = useState(0)
  
  // Заглушки для изображений
  const images = [
    {
      id: 1,
      src: nutrition1,
      title: 'Здоровое питание'
    },
    {
      id: 2,
      src: nutrition2,
      title: 'Сбалансированный рацион'
    },
    {
      id: 3,
      src: nutrition3,
      title: 'Персональный план'
    },
    {
      id: 4,
      src: nutrition4,
      title: 'Результаты'
    }
  ]

  useEffect(() => {
    const interval = setInterval(() => {
      setCurrentIndex((prev) => (prev + 1) % images.length)
    }, 3000)

    return () => clearInterval(interval)
  }, [images.length])

  const goToPrevious = () => {
    setCurrentIndex((prev) => (prev - 1 + images.length) % images.length)
  }

  const goToNext = () => {
    setCurrentIndex((prev) => (prev + 1) % images.length)
  }

  const goToSlide = (index) => {
    setCurrentIndex(index)
  }

  return (
    <div className="slider-container-nutrition">
      <div className="slider-wrapper-nutrition">
        {images.map((img, index) => (
          <div
            key={img.id}
            className={`slide-nutrition ${index === currentIndex ? 'active' : ''}`}
          >
            <img src={img.src} alt={img.title} className="slide-image-nutrition" />
            <div className="slide-overlay-nutrition"></div>
            <div className="slide-content-nutrition">
              <h3 className="slide-title-nutrition">{img.title}</h3>
            </div>
          </div>
        ))}
      </div>
      <button className="slider-btn-nutrition prev-nutrition" onClick={goToPrevious}>
        <ChevronLeft className="slider-icon-nutrition" size={28} />
      </button>
      <button className="slider-btn-nutrition next-nutrition" onClick={goToNext}>
        <ChevronRight className="slider-icon-nutrition" size={28} />
      </button>
      <div className="slider-dots-nutrition">
        {images.map((_, index) => (
          <button
            key={index}
            className={`dot-nutrition ${index === currentIndex ? 'active' : ''}`}
            onClick={() => goToSlide(index)}
            aria-label={`Go to slide ${index + 1}`}
          />
        ))}
      </div>
    </div>
  )
}

export default ImageSlider

